<?php 
/*
Plugin Name: Wordpress Mastodon Reposter 
Plugin URI: https://www.ericmaechler.com
Description: Repost your WordPress Posts into Mastodon (<a href="options-general.php?page=QGA_cbblky">Settings</a>)
Author: Eric-Oliver Mächler
Version: 1.3
Author URI: https://www.ericmaechler.com
Requires at least: 6.0
Tested up to: 6.6.2
*/

//menu
include("inc/conf.php");

include("add_btn.php");

include("add_dashboard_link.php");




/* ##########################################
##### MEHRSPRACHIGKEIT
#############################################*/
function mehrsprachigkeit_lang_wpmdrp() {
    load_plugin_textdomain( 'wordpress-mastodon-reposter', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
  }
  add_action('init', 'mehrsprachigkeit_lang_wpmdrp');
/* ##########################################
##### CSS Stylesheet Integration
#############################################*/
function wpmdrp_enqueue_styles() {
$php_file = plugins_url( 'css/style.php', __FILE__ );
wp_enqueue_style( 'wpmdrp-style', $php_file );
}

add_action( 'admin_enqueue_scripts', 'wpmdrp_enqueue_styles' );
add_action( 'wp_enqueue_scripts', 'wpmdrp_enqueue_styles' );



/* ##########################################
##### UPDATER
#############################################*/

require 'plugin-update-checker/plugin-update-checker.php';
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

$myUpdateChecker = PucFactory::buildUpdateChecker(
	'https://plugins.ericmaechler.com/wordpress-mastodon-reposter/details.json',
	__FILE__, 
	'wordpress-mastodon-reposter'
);

?>