<?php
if (!defined('ABSPATH')) exit; // Direktzugriff verhindern

function repost_Form_wpmdrp() {
    $token = get_option('wpmdrp_token');

    // JSON-Log-Dateipfad im Uploads-Ordner ermitteln
    $upload_dir = wp_upload_dir();
    $log_file_path = trailingslashit($upload_dir['basedir']) . 'wordpress-mastodon-reposter-log.json';

    // JSON-Logdatei initialisieren (falls nicht vorhanden)
    if (!file_exists($log_file_path)) {
        file_put_contents($log_file_path, json_encode([]));
    }

    // Beitrag verarbeiten
    if (isset($_GET['post_id'])) {
        $post_id = intval($_GET['post_id']);
        if (get_post_status($post_id)) {
            $post_title = get_the_title($post_id);
            $post_url = get_permalink($post_id);
            $hashtags = wp_get_post_tags($post_id, ['fields' => 'names']);
            $hashtags_text = implode(' ', array_map(function($tag) {
                return '#' . sanitize_title($tag);
            }, $hashtags));

            // UTM-Parameter überprüfen und hinzufügen, falls aktiviert
            $wpmdrp_utm = get_option('wpmdrp_utm'); // Option aus der DB abrufen
            if ($wpmdrp_utm == '1') {
                $post_url = add_query_arg([
                    'utm_source' => 'mastodon',
                    'utm_medium' => 'cpc'
                ], $post_url);
            }

            // Mastodon-Status
            $input_text = $post_title . "\n" . $post_url . "\n" . $hashtags_text;

            // Mastodon API
            $post_data = ['status' => $input_text];
            $response = jwt_request($token, $post_data);

            if ($response) {
                echo '<p>' . __('Post successfully sent to Mastodon', 'wordpress-mastodon-reposter') . '</p>';

                // JSON-Log aktualisieren
                $log_data = json_decode(file_get_contents($log_file_path), true);
                $log_data[] = [
                    'timestamp' => time(),
                    'post_id' => $post_id,
                    'post_title' => $post_title,
                    'post_url' => $post_url,
                ];
                file_put_contents($log_file_path, json_encode($log_data, JSON_PRETTY_PRINT));
            } else {
                echo '<p>' . __('Error while sending to Mastodon', 'wordpress-mastodon-reposter') . '</p>';
            }
        } else {
            echo '<p>' . __('Post-ID Error', 'wordpress-mastodon-reposter') . '</p>';
        }
    } else {
        echo '<p>' . __('No Post-ID', 'wordpress-mastodon-reposter') . '</p>';
    }

    // Button zum Löschen des Logs
    if (isset($_POST['delete_log'])) {
        if (file_exists($log_file_path)) {
            unlink($log_file_path);
            echo '<p>' . __('Log successfully deleted', 'wordpress-mastodon-reposter') . '</p>';
        } else {
            echo '<p>' . __('No Log file found', 'wordpress-mastodon-reposter') . '</p>';
        }
    }

    // JSON-Logdatei nur auslesen, wenn sie existiert
    $log_data = [];
    if (file_exists($log_file_path)) {
        $log_data = json_decode(file_get_contents($log_file_path), true);
    }

    // Log-Daten umkehren, damit der neueste Beitrag zuerst angezeigt wird
    $log_data = array_reverse($log_data);

    // HTML-Ausgabe
    ?>
    <div class="wrap">
        <h2>Repost-Sektion</h2>
        <form method="post">
            <button type="submit" name="delete_log" class="button button-danger">Delete Log</button>
        </form>

        <h3>Log-Daten</h3>
        <?php
        if (!empty($log_data)) {
            echo '<table class="wp-list-table widefat fixed striped posts">';
            echo '<thead><tr>';
            echo '<th>' . __('Date and Time', 'wordpress-mastodon-reposter') . '</th>';
            echo '<th>' . __('Title', 'wordpress-mastodon-reposter') . '</th>';
            echo '<th>' . __('URL', 'wordpress-mastodon-reposter') . '</th>';
            echo '</tr></thead>';

            echo '<tbody>';
            foreach ($log_data as $entry) {
                $timestamp = $entry['timestamp'];
                $date_time = date('d.m.Y H:i:s', $timestamp); // Datum und Uhrzeit formatieren
                $post_title = $entry['post_title'];
                $post_url = $entry['post_url']; // URL des Beitrags
                echo '<tr><td>' . esc_html($date_time) . '</td><td>' . esc_html($post_title) . '</td><td><a href="' . esc_url($post_url) . '" target="_blank">Link</a></td></tr>';
            }
            echo '</tbody></table>';
        } else {
            echo '<p>' . __('No log data available', 'wordpress-mastodon-reposter') . '</p>';
        }
        ?>
    </div>
    <?php
}

// Mastodon API-Funktion
function jwt_request($token, $post) {
    $wpmdrp_url = get_option('wpmdrp_url');

    $ch = curl_init($wpmdrp_url . '/api/v1/statuses');
    $post = json_encode($post);
    $authorization = "Authorization: Bearer " . $token;

    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', $authorization]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Fehler: ' . curl_error($ch);
        curl_close($ch);
        return null;
    }

    curl_close($ch);
    return json_decode($result, true);
}
?>
