<?php
// Sicherheitsprüfung
if (!defined('ABSPATH')) exit;



function add_mastodon_repost_action($actions, $post) {
    // Nur für Benutzer mit Administratorrechten sichtbar
    if (!current_user_can('administrator')) {
        return $actions;
    }

    // Mastodon-Repost-Link
    $repost_url = esc_url(admin_url('admin.php?page=repost_wpmdrp&post_id=' . $post->ID));
    $actions['mastodon_repost'] = '<a href="' . $repost_url . '" target="_blank">' . __('Repost auf Mastodon', 'wordpress-mastodon-reposter') . '</a>';


    return $actions;
}


// Filter für Beiträge
add_filter('post_row_actions', 'add_mastodon_repost_action', 10, 2);

// Filter für Seiten
add_filter('page_row_actions', 'add_mastodon_repost_action', 10, 2);


?>