<?php
// Fügt den Button am Ende des Inhalts hinzu
function add_mastodon_button_to_posts($content) {
    // Überprüfen, ob der aktuelle Benutzer Administrator ist
    if (is_admin() || !current_user_can('administrator')) {
        return $content;
    }

    // Holen der aktuellen Post-ID und des Post-Typs
    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);

    

    // Button-HTML-Code mit Post-ID als URL-Parameter
    $button_html = '<a href="' . esc_url(admin_url('admin.php?page=repost_wpmdrp&post_id=' . $post_id)) . '" class="mastodon_btn" target="_blank"><img src="' . esc_url(plugins_url('img/mastodon-icon.png', __FILE__)) . '" alt="Mastodon Icon"></a>';


    // Button ans Ende des Inhalts anhängen
    return $content . $button_html;
}

$wpmdrp_floatingbtn = get_option('wpmdrp_floatingbtn');
if ($wpmdrp_floatingbtn == '1'){

// Filter hinzufügen, um den Button zu integrieren
add_filter('the_content', 'add_mastodon_button_to_posts');
}
?>
